void Main()
{
	var foo = new Foo();
	
	// Test bez wywoływania SuspendEvents()
	foo.FireSomeEvent(); 
	
	// Test z zawieszeniem zdarzenia:
	using (foo.SuspendEvents())
	{
		foo.FireSomeEvent();
	}

	// Test bez wywoływania SuspendEvents()
	foo.FireSomeEvent();

}

class Foo
{
	int _suspendCount;

	public IDisposable SuspendEvents()
	{
		_suspendCount++;
		return new SuspendToken (this);
	}

	public void FireSomeEvent()
	{
		if (_suspendCount == 0)
			"Zdarzenie zostałoby zgłoszone".Dump();
		else
			"Zdarzenie stłumione".Dump();
	}

	class SuspendToken : IDisposable
	{
		Foo _foo;
		public SuspendToken (Foo foo) => _foo = foo;
		public void Dispose()
		{
			if (_foo != null) _foo._suspendCount--;
			_foo = null;
		}
	}
}